;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: DelSig_1INT.asm
;;   Version: 1.0, Updated on 2004/08/11 at 11:08:56
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler interrupt service routine for the Delta-Sigma ADC
;;               User Module based on the Type 2 Decimator. This code works for
;;               both the first and second-order modulator topologies where
;;               the decimation rate requires no extra shift of the data
;;               in software.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"
include "memory.inc"
include "DelSig_1.inc"


;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------

export _DelSig_1_ADConversion_ISR
export _DelSig_1_iResult
export  DelSig_1_iResult
export _DelSig_1_bfStatus
export  DelSig_1_bfStatus


;-----------------------------------------------
; Variable Allocation
;-----------------------------------------------
AREA InterruptRAM (RAM, REL, CON)

_DelSig_1_iResult:
 DelSig_1_iResult:                 blk 2             ;ADC output value
_DelSig_1_bfStatus:
 DelSig_1_bfStatus:                blk 1             ;Data Valid Flag


;-----------------------------------------------
;  Private Symbols
;-----------------------------------------------
MSB:                               equ 0
LSB:                               equ 1
RES:                               equ 14
UMAX:                              equ (1<<RES) - 1  ; 2^RES - 1


;@PSoC_UserCode_INIT@ (Do not change this line.)
;---------------------------------------------------
; Insert your custom declarations below this banner
;---------------------------------------------------

;------------------------
; Includes
;------------------------

;------------------------
; Exports
;------------------------

;------------------------
; Constant Definitions
;------------------------

;------------------------
; Variable Allocation
;------------------------

;---------------------------------------------------
; Insert your custom declarations above this banner
;---------------------------------------------------
;@PSoC_UserCode_END@ (Do not change this line.)


AREA UserModules (ROM, REL, CON)

;;=============================================================================
;;  FUNCTION NAME: _DelSig_1_ADConversion_ISR:
;;=============================================================================
;;
_DelSig_1_ADConversion_ISR:
   push  A
   mov   A, reg[DEC_DH]
   cmp   A, >(UMAX+1)                            ; Is value >= 2^RES?
   jc    .NoOverflow                             ;    No, Data is in normal range
   mov   [DelSig_1_iResult+MSB], >UMAX           ;   Yes, limit to 2^RES - 1
   mov   [DelSig_1_iResult+LSB], <UMAX           ;          as expected
   jmp   .ConversionReady

.NoOverflow:
   mov   [DelSig_1_iResult+MSB], A
   mov   A, reg[DEC_DL]
   mov   [DelSig_1_iResult+LSB], A

.ConversionReady:
IF DelSig_1_2S_COMPLEMENT
   ; Internal hardware format is unsigned; optionally convert so zero is half scale
   sub   [DelSig_1_iResult+MSB], >(UMAX+1)>>1
ENDIF
   mov [DelSig_1_bfStatus], DelSig_1_DATA_READY_BIT            

   ;@PSoC_UserCode_BODY@ (Do not change this line.)
   ;---------------------------------------------------
   ; Insert your custom code below this banner
   ;---------------------------------------------------


   ;---------------------------------------------------
   ; Insert your custom code above this banner
   ;---------------------------------------------------
   ;@PSoC_UserCode_END@ (Do not change this line.)

   pop A
   reti

; end of file DelSig_1INT.asm
