	cpu LMM
	.module main.c
	.area data(ram, con, rel)
_inputCmdChk::
	.byte 0
	.dbfile ./main.c
	.dbsym e inputCmdChk _inputCmdChk c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_inputLen::
	.byte 0
	.dbsym e inputLen _inputLen c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_currentMode::
	.byte 1
	.dbsym e currentMode _currentMode c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogcount::
	.byte 0
	.dbsym e analogcount _analogcount c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_analogPort::
	.byte 0
	.dbsym e analogPort _analogPort c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_needUpdate::
	.byte 0
	.dbsym e needUpdate _needUpdate c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_resendtimer::
	.byte 128
	.dbsym e resendtimer _resendtimer c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_joyxacc::
	.word 0,0
	.dbsym e joyxacc _joyxacc L
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_joyyacc::
	.word 0,0
	.dbsym e joyyacc _joyyacc L
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_joymove::
	.byte 0
	.dbsym e joymove _joymove c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_moveup::
	.byte 0
	.dbsym e moveup _moveup c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_movedown::
	.byte 0
	.dbsym e movedown _movedown c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_moveright::
	.byte 0
	.dbsym e moveright _moveright c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_moveleft::
	.byte 0
	.dbsym e moveleft _moveleft c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_buttonDownCount::
	.word 0
	.dbsym e buttonDownCount _buttonDownCount i
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_badchars::
	.byte 0
	.dbsym e badchars _badchars c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area data(ram, con, rel)
	.dbfile ./main.c
_batterystate::
	.byte 255
	.dbsym e batterystate _batterystate c
	.area data(ram, con, rel)
	.dbfile ./main.c
	.area text(rom, con, rel)
	.dbfile ./main.c
	.dbfunc e main _main fV
_main::
	.dbline -1
	.dbline 95
; //----------------------------------------------------------------------------
; // C main line
; //----------------------------------------------------------------------------
; 
; #include <m8c.h>        // part specific constants and macros
; #include <stdlib.h>
; #include <flashblock.h>
; 
; #include "PSoCAPI.h"    // PSoC API definitions for all User Modules
; #include "orcsplash.h"
; #include "glcd.h" 
; #include "ed_host_int.h"
; #include "util.h"
; 
; #include "fnt46.h"
; #include "fnt58.h"
; #include "fnt68.h"
; #include "fnt88.h"
; 
; #include "error.h"
; #include "config.h"
; 
; #define BATTERYUPDATEINTERVAL 256
; #define INPUTCMDMAXLEN  	  72    // long enough for a 64 byte raw write
; #define PORT0PULLUPS 	      0xe0
; #define RESEND_INTERVAL       128   // 4Hz. We send this often, if there's no reason to.
; #define CONFIG_BUTTON_THRESH  1024  // 2 seconds
; #define BATVOLTAGE_X 96
; 
; // how far from center do we need to be in order to pay any attention
; // to the joystick?
; #define JOY_THRESH_MIN (0x18)
; 
; // how much must the joystick accumulate in order for us to call it an 
; // autorepreat?
; #define JOY_THRESH_AUTOREPEAT (18*128*8)
; #define JOY_THRESH_PRESS (2*128*8)
; 
; ////////////// GLOBALS
; 
; char		  inputCmd[INPUTCMDMAXLEN];
; unsigned char inputCmdChk=0;
; unsigned char inputLen=0;
; 
; int 		  joyx, joyy, batteryvoltage;
; 
; int 		  batteryUpdateCount;
; 
; unsigned char currentMode=MODE_PLOT;
; 
; unsigned char analogcount=0;
; unsigned char analogPort=0;
; 
; unsigned char buttons;
; 
; unsigned char needUpdate=0;
; unsigned char resendtimer=RESEND_INTERVAL;
; 
; long 		  joyxacc=0, joyyacc=0;
; unsigned char joymove=0;
; unsigned char moveup=0, movedown=0, moveright=0, moveleft=0;
; unsigned int  buttonDownCount=0;
; 
; int 		  debounceDelay;
; 
; unsigned char lastSleepCounter;
; 
; unsigned char badchars=0;
; 
; unsigned char batterystate=255;
; 
; ////////////// EXTERNS
; extern params_t 	  params;
; extern unsigned char  sleepcounter;
; 
; ///////////// PROTOTYPES
; 
; unsigned char convertJoyX(void);
; unsigned char convertJoyY(void);
; void ProcessInputChar(char b);
; void handlePacket(void);
; void sendAck(unsigned char flags, unsigned char error);
; unsigned char chksend(unsigned char chk, unsigned char c);
; void UpdateAnalog(void);
; void UpdateButtons(void);
; void SendPacket(unsigned char flags);
; void doSleepInterval(void);
; void DrawBatteryVoltage(unsigned char x, unsigned char y);
; 
; extern void calibrate(void);
; 
; ///////////// MAIN
; 
; void main()
; {
	.dbline 96
; 	sleepcounter=0;
	mov REG[0xd0],>_sleepcounter
	mov [_sleepcounter],0
	.dbline 97
; 	lastSleepCounter=sleepcounter;
	mov A,[_sleepcounter]
	mov REG[0xd0],>_lastSleepCounter
	mov [_lastSleepCounter],A
	.dbline 98
;  	INT_MSK0|=0x40;
	or REG[0xe0],64
	.dbline 100
; 	
; 	PRT0DR=PORT0PULLUPS;
	mov REG[ 0],-32
	.dbline 102
; 
; 	M8C_EnableGInt;
		or  F, 01h

	.dbline 104
; 	
; 	ED_HOST_init();
	push X
	xcall _ED_HOST_init
	mov REG[0xd0],>__r0
	pop X
	.dbline 105
; 	UART_HOST_IntCntl(UART_HOST_ENABLE_RX_INT | UART_HOST_ENABLE_TX_INT);
	push X
	mov A,3
	xcall _UART_HOST_IntCntl
	.dbline 106
;   	UART_HOST_Start(UART_HOST_PARITY_NONE);
	mov A,0
	xcall _UART_HOST_Start
	.dbline 108
;   
;  	AMUX4_1_Start();
	xcall _AMUX4_1_Start
	.dbline 109
;  	RefMux_1_Start(RefMux_1_HIGHPOWER);
	mov A,3
	xcall _RefMux_1_Start
	.dbline 111
; 
; 	DelSig_1_Start(DelSig_1_HIGHPOWER);
	mov A,3
	xcall _DelSig_1_Start
	.dbline 112
; 	DelSig_1_StartAD();
	xcall _DelSig_1_StartAD
	.dbline 114
; 	
; 	PWM16_LOWBAT_Start();
	xcall _PWM16_LOWBAT_Start
	pop X
	.dbline 116
; 	
; 	GLCD_Init();	
	xcall _GLCD_Init
	.dbline 117
; 	GLCD_DrawImage(orcsplash);
	mov A,>_orcsplash
	push A
	mov A,<_orcsplash
	push A
	xcall _GLCD_DrawImage
	add SP,-2
	.dbline 119
; 	
; 	GLCD_ConsoleTop=1;
	mov REG[0xd0],>_GLCD_ConsoleTop
	mov [_GLCD_ConsoleTop],1
	.dbline 120
; 	GLCD_ConsoleHeight=7;
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov [_GLCD_ConsoleHeight],7
	.dbline 121
; 	GLCD_ConsoleLeft=0;
	mov REG[0xd0],>_GLCD_ConsoleLeft
	mov [_GLCD_ConsoleLeft],0
	.dbline 122
; 	GLCD_ConsoleWidth=32;
	mov REG[0xd0],>_GLCD_ConsoleWidth
	mov [_GLCD_ConsoleWidth],32
	.dbline 123
; 	GLCD_ConsoleY=5; //second to bottom most line
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],5
	.dbline 125
; 	
; 	loadPrefs();
	xcall _loadPrefs
	.dbline 127
; 
; 	batteryUpdateCount=128; // give us a little time to read the A/Ds before drawing the voltage.
	mov REG[0xd0],>_batteryUpdateCount
	mov [_batteryUpdateCount+1],-128
	mov [_batteryUpdateCount],0
	xjmp L6
X0:
	.dbline 130
; 	
; 	while(1)
; 	 {
L8:
	.dbline 132
	.dbline 133
	push X
	xcall _ED_HOST_getData
	mov REG[0xd0],>__r0
	pop X
	push A
	xcall _ProcessInputChar
	add SP,-1
	.dbline 134
L9:
	.dbline 131
; 	 	while (ED_HOST_isData())
	push X
	xcall _ED_HOST_isData
	mov REG[0xd0],>__r0
	pop X
	cmp A,0
	jnz L8
	.dbline 136
; 	 	{
; 	 		ProcessInputChar(ED_HOST_getData());
; 		}
; 
; 		UpdateAnalog();
	xcall _UpdateAnalog
	.dbline 138
; 		
; 		UpdateButtons();
	xcall _UpdateButtons
	.dbline 140
; 
; 		if (debounceDelay>0)
	mov REG[0xd0],>_debounceDelay
	mov A,[_debounceDelay]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_debounceDelay
	mov A,[_debounceDelay+1]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L11
	mov A,[__rX]
	jz L11
X2:
	.dbline 141
; 			debounceDelay--;
	mov REG[0xd0],>_debounceDelay
	dec [_debounceDelay+1]
	sbb [_debounceDelay],0
L11:
	.dbline 143
; 
; 		if ((needUpdate || resendtimer==0) && debounceDelay==0)
	mov REG[0xd0],>_needUpdate
	cmp [_needUpdate],0
	jnz L15
	mov REG[0xd0],>_resendtimer
	cmp [_resendtimer],0
	jnz L13
L15:
	mov REG[0xd0],>_debounceDelay
	cmp [_debounceDelay],0
	jnz L13
	cmp [_debounceDelay+1],0
	jnz L13
X3:
	.dbline 144
; 		{
	.dbline 145
; 			resendtimer=RESEND_INTERVAL;
	mov REG[0xd0],>_resendtimer
	mov [_resendtimer],-128
	.dbline 146
; 			needUpdate=0;
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],0
	.dbline 147
; 			SendPacket(0x80);
	mov A,-128
	push A
	xcall _SendPacket
	add SP,-1
	.dbline 149
; 			// this delay effects a ~9ms max update rate
; 			debounceDelay=700;
	mov REG[0xd0],>_debounceDelay
	mov [_debounceDelay+1],-68
	mov [_debounceDelay],2
	.dbline 150
; 		}
L13:
	.dbline 152
; 
; 		if (lastSleepCounter!=sleepcounter)
	mov REG[0xd0],>_lastSleepCounter
	mov A,[_lastSleepCounter]
	mov REG[0xd0],>_sleepcounter
	cmp A,[_sleepcounter]
	jz L16
	.dbline 153
; 			doSleepInterval();
	xcall _doSleepInterval
L16:
	.dbline 155
; 
; 		if (buttonDownCount>=CONFIG_BUTTON_THRESH)
	mov REG[0xd0],>_buttonDownCount
	cmp [_buttonDownCount],4
	jnz X5
	cmp [_buttonDownCount+1],0
	jz X4
X5:
	jc L18
X4:
	.dbline 156
; 		{
	.dbline 157
; 			calibrate();
	xcall _calibrate
	.dbline 158
; 			buttonDownCount=0;
	mov REG[0xd0],>_buttonDownCount
	mov [_buttonDownCount+1],0
	mov [_buttonDownCount],0
	.dbline 159
; 		}
L18:
	.dbline 161
L6:
	.dbline 129
	xjmp L9
X1:
	.dbline -2
	.dbline 162
; 		
; 	}
; }
L4:
	.dbline 0 ; func end
	jmp .
	.dbend
	.dbfunc e convertJoyX _convertJoyX fc
;              v -> X+0
_convertJoyX::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 165
; 
; unsigned char convertJoyX()
; {
	.dbline 168
; 	int v;
; 	
; 	if (joyx>params.joycx)
	mov REG[0xd0],>_joyx
	mov A,[_joyx]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov REG[0xd0],>_params
	mov A,[_params]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyx
	mov A,[_joyx+1]
	mov REG[0xd0],>_params
	sub A,[_params+1]
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L21
	mov A,[__rX]
	jz L21
X6:
	.dbline 169
; 		v=128+(127L*(joyx-params.joycx))/(params.joyxmax-params.joycx);
	mov REG[0xd0],>_joyx
	mov A,[_joyx+1]
	mov REG[0xd0],>_params
	sub A,[_params+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_joyx
	mov A,[_joyx]
	mov REG[0xd0],>_params
	sbb A,[_params]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X7
	mov [__r1],-1
	mov [__r0],-1
	jmp X8
X7:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X8:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,0
	push A
	push A
	push A
	mov A,127
	push A
	xcall __mul_32X32_32
	add SP,-4
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	mov REG[0xd0],>_params
	mov A,[_params+6+1]
	sub A,[_params+1]
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_params
	mov A,[_params+6]
	sbb A,[_params]
	mov REG[0xd0],>__r0
	mov [__r4],A
	mov A,[__r5]
	mov [__r7],A
	mov A,[__r4]
	mov [__r6],A
	tst [__r6],-128
	jz X9
	mov [__r5],-1
	mov [__r4],-1
	jmp X10
X9:
	mov REG[0xd0],>__r0
	mov [__r5],0
	mov [__r4],0
X10:
	mov REG[0xd0],>__r0
	mov A,[__r4]
	push A
	mov A,[__r5]
	push A
	mov A,[__r6]
	push A
	mov A,[__r7]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	add SP,-4
	add [__r3],-128
	adc [__r2],0
	adc [__r1],0
	adc [__r0],0
	mov A,[__r3]
	mov [__r1],A
	mov A,[__r2]
	mov [__r0],A
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	xjmp L22
L21:
	.dbline 171
; 	else
; 		v=(128L*(joyx-params.joyxmin))/(params.joycx-params.joyxmin);
	mov REG[0xd0],>_joyx
	mov A,[_joyx+1]
	mov REG[0xd0],>_params
	sub A,[_params+4+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_joyx
	mov A,[_joyx]
	mov REG[0xd0],>_params
	sbb A,[_params+4]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X11
	mov [__r1],-1
	mov [__r0],-1
	jmp X12
X11:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X12:
	mov REG[0xd0],>__r0
	mov A,7
X13:
	mov REG[0xd0],>__r0
	asl [__r3]
	rlc [__r2]
	rlc [__r1]
	rlc [__r0]
	dec A
	jnz X13
	mov REG[0xd0],>_params
	mov A,[_params+1]
	sub A,[_params+4+1]
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_params
	mov A,[_params]
	sbb A,[_params+4]
	mov REG[0xd0],>__r0
	mov [__r4],A
	mov A,[__r5]
	mov [__r7],A
	mov A,[__r4]
	mov [__r6],A
	tst [__r6],-128
	jz X14
	mov [__r5],-1
	mov [__r4],-1
	jmp X15
X14:
	mov REG[0xd0],>__r0
	mov [__r5],0
	mov [__r4],0
X15:
	mov REG[0xd0],>__r0
	mov A,[__r4]
	push A
	mov A,[__r5]
	push A
	mov A,[__r6]
	push A
	mov A,[__r7]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	pop A
	add SP,-4
	mov A,[__r3]
	mov [__r1],A
	mov A,[__r2]
	mov [__r0],A
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
L22:
	.dbline 173
; 
; 	if (v<0)
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L26
	mov A,[__rX]
	jz L26
X16:
	.dbline 174
; 		v=0;
	mov [X+1],0
	mov [X+0],0
L26:
	.dbline 175
; 	if (v>255)
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-1
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L28
	mov A,[__rX]
	jz L28
X17:
	.dbline 176
; 		v=255;
	mov [X+1],-1
	mov [X+0],0
L28:
	.dbline 178
; 		
; 	return v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	.dbline -2
L20:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v 0 I
	.dbend
	.dbfunc e convertJoyY _convertJoyY fc
;              v -> X+0
_convertJoyY::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 182
; }
; 
; unsigned char convertJoyY()
; {
	.dbline 185
; 	int v;
; 
; 	if (joyy>params.joycy)
	mov REG[0xd0],>_joyy
	mov A,[_joyy]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov REG[0xd0],>_params
	mov A,[_params+2]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyy
	mov A,[_joyy+1]
	mov REG[0xd0],>_params
	sub A,[_params+2+1]
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L31
	mov A,[__rX]
	jz L31
X18:
	.dbline 186
; 		v=128+(127L*(joyy-params.joycy))/(params.joyymax-params.joycy);
	mov REG[0xd0],>_joyy
	mov A,[_joyy+1]
	mov REG[0xd0],>_params
	sub A,[_params+2+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_joyy
	mov A,[_joyy]
	mov REG[0xd0],>_params
	sbb A,[_params+2]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X19
	mov [__r1],-1
	mov [__r0],-1
	jmp X20
X19:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X20:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,0
	push A
	push A
	push A
	mov A,127
	push A
	xcall __mul_32X32_32
	add SP,-4
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	mov REG[0xd0],>_params
	mov A,[_params+10+1]
	sub A,[_params+2+1]
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_params
	mov A,[_params+10]
	sbb A,[_params+2]
	mov REG[0xd0],>__r0
	mov [__r4],A
	mov A,[__r5]
	mov [__r7],A
	mov A,[__r4]
	mov [__r6],A
	tst [__r6],-128
	jz X21
	mov [__r5],-1
	mov [__r4],-1
	jmp X22
X21:
	mov REG[0xd0],>__r0
	mov [__r5],0
	mov [__r4],0
X22:
	mov REG[0xd0],>__r0
	mov A,[__r4]
	push A
	mov A,[__r5]
	push A
	mov A,[__r6]
	push A
	mov A,[__r7]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	add SP,-4
	add [__r3],-128
	adc [__r2],0
	adc [__r1],0
	adc [__r0],0
	mov A,[__r3]
	mov [__r1],A
	mov A,[__r2]
	mov [__r0],A
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	xjmp L32
L31:
	.dbline 188
; 	else
; 		v=(128L*(joyy-params.joyymin))/(params.joycy-params.joyymin);
	mov REG[0xd0],>_joyy
	mov A,[_joyy+1]
	mov REG[0xd0],>_params
	sub A,[_params+8+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov REG[0xd0],>_joyy
	mov A,[_joyy]
	mov REG[0xd0],>_params
	sbb A,[_params+8]
	mov REG[0xd0],>__r0
	mov [__r0],A
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X23
	mov [__r1],-1
	mov [__r0],-1
	jmp X24
X23:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X24:
	mov REG[0xd0],>__r0
	mov A,7
X25:
	mov REG[0xd0],>__r0
	asl [__r3]
	rlc [__r2]
	rlc [__r1]
	rlc [__r0]
	dec A
	jnz X25
	mov REG[0xd0],>_params
	mov A,[_params+2+1]
	sub A,[_params+8+1]
	mov REG[0xd0],>__r0
	mov [__r5],A
	mov REG[0xd0],>_params
	mov A,[_params+2]
	sbb A,[_params+8]
	mov REG[0xd0],>__r0
	mov [__r4],A
	mov A,[__r5]
	mov [__r7],A
	mov A,[__r4]
	mov [__r6],A
	tst [__r6],-128
	jz X26
	mov [__r5],-1
	mov [__r4],-1
	jmp X27
X26:
	mov REG[0xd0],>__r0
	mov [__r5],0
	mov [__r4],0
X27:
	mov REG[0xd0],>__r0
	mov A,[__r4]
	push A
	mov A,[__r5]
	push A
	mov A,[__r6]
	push A
	mov A,[__r7]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	pop A
	add SP,-4
	mov A,[__r3]
	mov [__r1],A
	mov A,[__r2]
	mov [__r0],A
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
L32:
	.dbline 190
; 
; 	if (v<0)
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L40
	mov A,[__rX]
	jz L40
X28:
	.dbline 191
; 		v=0;
	mov [X+1],0
	mov [X+0],0
L40:
	.dbline 192
; 	if (v>255)
	mov A,[X+0]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[X+1]
	sub A,-1
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L42
	mov A,[__rX]
	jz L42
X29:
	.dbline 193
; 		v=255;
	mov [X+1],-1
	mov [X+0],0
L42:
	.dbline 195
; 		
; 	return v;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	.dbline -2
L30:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v 0 I
	.dbend
	.dbfunc e ProcessInputChar _ProcessInputChar fV
;              b -> X-4
_ProcessInputChar::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 200
; }
; 
; 
; void ProcessInputChar(char b)
; {
	.dbline 202
; 	// wait for packet header
; 	if (inputLen==0 && b!=237)
	mov REG[0xd0],>_inputLen
	cmp [_inputLen],0
	jnz L45
	cmp [X-4],-19
	jz L45
	.dbline 203
; 	{
	.dbline 204
; 		badchars++;
	mov REG[0xd0],>_badchars
	inc [_badchars]
	.dbline 205
; 		return;
	xjmp L44
L45:
	.dbline 208
; 	}
; 	
; 	inputCmd[inputLen++]=b;
	mov REG[0xd0],>_inputLen
	mov A,[_inputLen]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add A,1
	mov REG[0xd0],>_inputLen
	mov [_inputLen],A
	mov REG[0xd0],>__r0
	add [__r1],<_inputCmd
	adc [__r0],>_inputCmd
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,[X-4]
	mvi [__r1],A
	.dbline 210
; 
; 	if (inputLen<2 || inputLen<inputCmd[1])
	mov REG[0xd0],>_inputLen
	cmp [_inputLen],2
	jz X30
	jc L50
X30:
	mov REG[0xd0],>_inputLen
	mov A,[_inputLen]
	mov REG[0xd0],>_inputCmd
	cmp A,[_inputCmd+1]
	jnc L47
X31:
L50:
	.dbline 211
; 		inputCmdChk=(inputCmdChk<<1) + b + (inputCmdChk&0x80 ? 1 : 0);
	mov REG[0xd0],>_inputCmdChk
	tst [_inputCmdChk],-128
	jz L52
	mov [X+1],1
	mov [X+0],0
	xjmp L53
L52:
	mov [X+1],0
	mov [X+0],0
L53:
	mov REG[0xd0],>_inputCmdChk
	mov A,[_inputCmdChk]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[X-4]
	add [__r1],A
	adc [__r0],0
	mov A,[X+1]
	add [__r1],A
	mov A,[X+0]
	adc [__r0],A
	mov A,[__r1]
	mov REG[0xd0],>_inputCmdChk
	mov [_inputCmdChk],A
L47:
	.dbline 213
; 			
; 	if (inputLen<2)
	mov REG[0xd0],>_inputLen
	cmp [_inputLen],2
	jnc L54
X32:
	.dbline 214
; 		return;
	xjmp L44
L54:
	.dbline 217
; 	
; 	// reject long packets
; 	if (inputCmd[1]>=INPUTCMDMAXLEN)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+1],72
	jz X33
	jc L56
X33:
	.dbline 218
; 		{
	.dbline 219
; 		inputLen=0;
	mov REG[0xd0],>_inputLen
	mov [_inputLen],0
	.dbline 220
; 		inputCmdChk=0;
	mov REG[0xd0],>_inputCmdChk
	mov [_inputCmdChk],0
	.dbline 221
; 		return;
	xjmp L44
L56:
	.dbline 225
; 		}
; 		
; 	// wait until we have the whole packet
; 	if (inputLen<inputCmd[1])
	mov REG[0xd0],>_inputLen
	mov A,[_inputLen]
	mov REG[0xd0],>_inputCmd
	cmp A,[_inputCmd+1]
	jnc L59
X34:
	.dbline 226
; 		return;
	xjmp L44
L59:
	.dbline 228
; 	
; 	if (inputCmdChk==inputCmd[inputLen-1])
	mov REG[0xd0],>_inputLen
	mov A,[_inputLen]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd-1
	adc [__r0],>_inputCmd-1
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [__r0],A
	mov REG[0xd0],>_inputCmdChk
	mov A,[_inputCmdChk]
	mov REG[0xd0],>__r0
	cmp A,[__r0]
	jnz L62
	.dbline 229
; 		{
	.dbline 230
; 		handlePacket();
	xcall _handlePacket
	.dbline 231
; 		}
	xjmp L63
L62:
	.dbline 233
; 	else
; 		badchars+=inputCmd[1];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+1]
	mov REG[0xd0],>_badchars
	add [_badchars],A
L63:
	.dbline 235
; 		
; 	inputLen=0;
	mov REG[0xd0],>_inputLen
	mov [_inputLen],0
	.dbline 236
; 	inputCmdChk=0;
	mov REG[0xd0],>_inputCmdChk
	mov [_inputCmdChk],0
	.dbline -2
	.dbline 237
; }
L44:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l b -4 c
	.dbend
	.dbfunc e handlePacket _handlePacket fV
;            len -> X+5
;             x2 -> X+4
;             y2 -> X+3
;              y -> X+2
;              x -> X+1
;            pos -> X+0
_handlePacket::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 243
; 
; #define BASEOFF 3
; #define FLAGSOFF 2
; 
; void handlePacket(void)
; {
	.dbline 246
; 	unsigned char x,y,x2,y2; 
; 	unsigned char pos;
; 	unsigned char len=inputCmd[1]-4; // length of actual command
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+1]
	sub A,4
	mov [X+5],A
	.dbline 248
; 	
; 	if (inputCmd[BASEOFF]=='*' && len==1)
	cmp [_inputCmd+3],42
	jnz L68
	cmp [X+5],1
	jnz L68
	.dbline 249
; 		{
	.dbline 250
; 		SendPacket(inputCmd[FLAGSOFF]);
	mov A,[_inputCmd+2]
	push A
	xcall _SendPacket
	add SP,-1
	.dbline 251
; 		return;
	xjmp L66
L68:
	.dbline 255
; 		}
; 		
; 	// HOME CURSOR:  H
; 	if (inputCmd[BASEOFF]=='H' && len==1)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],72
	jnz L72
	cmp [X+5],1
	jnz L72
	.dbline 256
; 		{
	.dbline 257
; 		GLCD_ConsoleHome();
	xcall _GLCD_ConsoleHome
	.dbline 258
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 259
; 		batteryUpdateCount=0;
	mov REG[0xd0],>_batteryUpdateCount
	mov [_batteryUpdateCount+1],0
	mov [_batteryUpdateCount],0
	.dbline 260
; 		return;
	xjmp L66
L72:
	.dbline 264
; 		}
; 
; 	// GOTO CURSOR:  Gxy
; 	if (inputCmd[BASEOFF]=='G' && len==3)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],71
	jnz L76
	cmp [X+5],3
	jnz L76
	.dbline 265
; 		{
	.dbline 266
; 		x=inputCmd[BASEOFF+1];
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 267
; 		y=inputCmd[BASEOFF+2];
	mov A,[_inputCmd+5]
	mov [X+2],A
	.dbline 268
; 		if (x>=GLCD_ConsoleWidth)
	mov REG[0xd0],>_GLCD_ConsoleWidth
	mov A,[X+1]
	cmp A,[_GLCD_ConsoleWidth]
	jz X35
	jc L81
X35:
	.dbline 269
; 			x=GLCD_ConsoleWidth-1;
	mov REG[0xd0],>_GLCD_ConsoleWidth
	mov A,[_GLCD_ConsoleWidth]
	sub A,1
	mov REG[0xd0],>__r0
	mov [X+1],A
L81:
	.dbline 270
; 		if (y>=GLCD_ConsoleHeight)
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[X+2]
	cmp A,[_GLCD_ConsoleHeight]
	jz X36
	jc L83
X36:
	.dbline 271
; 			y=GLCD_ConsoleHeight-1;
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov A,[_GLCD_ConsoleHeight]
	sub A,1
	mov REG[0xd0],>__r0
	mov [X+2],A
L83:
	.dbline 272
; 		GLCD_ConsoleX=x;
	mov A,[X+1]
	mov REG[0xd0],>_GLCD_ConsoleX
	mov [_GLCD_ConsoleX],A
	.dbline 273
; 		GLCD_ConsoleY=y;
	mov A,[X+2]
	mov REG[0xd0],>_GLCD_ConsoleY
	mov [_GLCD_ConsoleY],A
	.dbline 274
; 		GLCD_ConsoleNewlinePending=0;
	mov REG[0xd0],>_GLCD_ConsoleNewlinePending
	mov [_GLCD_ConsoleNewlinePending],0
	.dbline 275
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 276
; 		return;
	xjmp L66
L76:
	.dbline 280
; 		}
; 
; 	// PLOT POINT:   Pxy  (or repeated xy) Pxyxyxyxyxy
; 	if (inputCmd[BASEOFF]=='P' && len>=3 && (len&1)==1)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],80
	jnz L86
	cmp [X+5],3
	jz X37
	jc L86
X37:
	mov REG[0xd0],>__r0
	mov A,[X+5]
	and A,1
	cmp A,1
	jnz L86
	.dbline 281
; 		{
	.dbline 282
; 		pos=1;
	mov [X+0],1
	xjmp L90
L89:
	.dbline 284
; 		while (x2<len)
; 			{
	.dbline 285
; 			x=inputCmd[BASEOFF+pos];
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3
	adc [__r0],>_inputCmd+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	.dbline 286
; 			y=inputCmd[BASEOFF+pos+1];
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+1+3
	adc [__r0],>_inputCmd+1+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+2],A
	.dbline 287
; 			if (x>127)
	cmp [X+1],127
	jc L95
	jz L95
X38:
	.dbline 288
; 				x=127;
	mov [X+1],127
L95:
	.dbline 289
; 			if (y>63)
	cmp [X+2],63
	jc L97
	jz L97
X39:
	.dbline 290
; 				y=63;
	mov [X+2],63
L97:
	.dbline 291
	mov REG[0xd0],>_currentMode
	mov A,[_currentMode]
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_Plot
	add SP,-3
	.dbline 292
	add [X+0],2
	.dbline 293
L90:
	.dbline 283
	mov A,[X+4]
	cmp A,[X+5]
	jz X40
	jc L89
X40:
	.dbline 294
; 			GLCD_Plot(x,y,currentMode);
; 			pos+=2;
; 			}
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 295
; 		return;
	xjmp L66
L86:
	.dbline 299
; 		}
; 	
; 	// SET PLOT MODE:   Mx
; 	if (inputCmd[BASEOFF]=='M' && len==2)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],77
	jnz L100
	cmp [X+5],2
	jnz L100
	.dbline 300
; 		{
	.dbline 301
; 		currentMode=inputCmd[BASEOFF+1];
	mov A,[_inputCmd+4]
	mov REG[0xd0],>_currentMode
	mov [_currentMode],A
	.dbline 302
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 303
; 		return;
	xjmp L66
L100:
	.dbline 307
; 		}
; 	
; 	// DRAW LINE:     Lxyxy (or repeated, Lxyxyxyxy)
; 	if (inputCmd[BASEOFF]=='L' && len>=5 && (len&3)==1)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],76
	jnz L105
	cmp [X+5],5
	jz X41
	jc L105
X41:
	mov REG[0xd0],>__r0
	mov A,[X+5]
	and A,3
	cmp A,1
	jnz L105
	.dbline 308
; 		{
	.dbline 309
; 		pos=1;
	mov [X+0],1
	xjmp L109
L108:
	.dbline 311
; 		while (pos<len)
; 			{
	.dbline 312
; 			x=inputCmd[BASEOFF+pos];
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3
	adc [__r0],>_inputCmd+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+1],A
	.dbline 313
; 			y=inputCmd[BASEOFF+pos+1];
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+1+3
	adc [__r0],>_inputCmd+1+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+2],A
	.dbline 314
; 			x2=inputCmd[BASEOFF+pos+2];
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+2+3
	adc [__r0],>_inputCmd+2+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+4],A
	.dbline 315
; 			y2=inputCmd[BASEOFF+pos+3];
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3+3
	adc [__r0],>_inputCmd+3+3
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	mov [X+3],A
	.dbline 316
; 			if (x>127)
	cmp [X+1],127
	jc L118
	jz L118
X42:
	.dbline 317
; 				x=127;
	mov [X+1],127
L118:
	.dbline 318
; 			if (y>63)
	cmp [X+2],63
	jc L120
	jz L120
X43:
	.dbline 319
; 				y=63;
	mov [X+2],63
L120:
	.dbline 320
; 			if (x2>127)
	cmp [X+4],127
	jc L122
	jz L122
X44:
	.dbline 321
; 				x2=127;
	mov [X+4],127
L122:
	.dbline 322
; 			if (y2>63)
	cmp [X+3],63
	jc L124
	jz L124
X45:
	.dbline 323
; 				y2=63;
	mov [X+3],63
L124:
	.dbline 324
	mov REG[0xd0],>_currentMode
	mov A,[_currentMode]
	push A
	mov A,[X+3]
	push A
	mov A,[X+4]
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawLine
	add SP,-5
	.dbline 325
	add [X+0],4
	.dbline 326
L109:
	.dbline 310
	mov A,[X+0]
	cmp A,[X+5]
	jz X46
	jc L108
X46:
	.dbline 327
; 			GLCD_DrawLine(x,y,x2,y2,currentMode);
; 			pos+=4;
; 			}
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 328
; 		return;
	xjmp L66
L105:
	.dbline 332
; 		}
; 
; 	// CLEAR:        C
; 	if (inputCmd[BASEOFF]=='C' && len==1)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],67
	jnz L127
	cmp [X+5],1
	jnz L127
	.dbline 333
; 		{
	.dbline 334
; 		GLCD_Clear();
	xcall _GLCD_Clear
	.dbline 335
; 		GLCD_DrawCharXor=0x7f;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],127
	.dbline 336
; 		GLCD_DrawStringC(0,0,"                                ",fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,>L130
	push A
	mov A,<L130
	push A
	mov A,0
	push A
	push A
	xcall _GLCD_DrawStringC
	.dbline 337
; 		GLCD_DrawCharXor=0;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],0
	.dbline 339
; 
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-8
	.dbline 340
; 		batteryUpdateCount=0;
	mov REG[0xd0],>_batteryUpdateCount
	mov [_batteryUpdateCount+1],0
	mov [_batteryUpdateCount],0
	.dbline 341
; 		return;
	xjmp L66
L127:
	.dbline 346
; 		}
; 
; 	// FILL:       Fxy
; 	// x in even columns, y in odd columns.
; 	if (inputCmd[BASEOFF]=='F' && len==3)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],70
	jnz L132
	cmp [X+5],3
	jnz L132
	.dbline 347
; 		{
	.dbline 348
; 		x=inputCmd[BASEOFF+1];
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 349
; 		y=inputCmd[BASEOFF+2];
	mov A,[_inputCmd+5]
	mov [X+2],A
	.dbline 350
; 		GLCD_Fill(x,y);
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_Fill
	.dbline 351
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-4
	.dbline 352
; 		batteryUpdateCount=0;
	mov REG[0xd0],>_batteryUpdateCount
	mov [_batteryUpdateCount+1],0
	mov [_batteryUpdateCount],0
	.dbline 353
; 		return;
	xjmp L66
L132:
	.dbline 357
; 		}
; 	
; 	// RAW Read:    rxyl (l=len)
; 	if (inputCmd[BASEOFF]=='r' && len>=3)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],114
	jnz L138
	cmp [X+5],3
	jz X47
	jc L138
X47:
	.dbline 358
; 		{
	.dbline 359
; 		x=inputCmd[BASEOFF+1];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 360
; 		y=inputCmd[BASEOFF+2];
	mov A,[_inputCmd+5]
	mov [X+2],A
	.dbline 361
; 		x2=inputCmd[BASEOFF+3];
	mov A,[_inputCmd+6]
	mov [X+4],A
	.dbline 363
; 		
; 		if (x>127)
	cmp [X+1],127
	jc L144
	jz L144
X48:
	.dbline 364
; 			x=127;
	mov [X+1],127
L144:
	.dbline 365
; 		if (y>63)
	cmp [X+2],63
	jc L146
	jz L146
X49:
	.dbline 366
; 			y=63;
	mov [X+2],63
L146:
	.dbline 368
; 
; 		len=inputCmd[FLAGSOFF]; // remember the original flags
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	mov [X+5],A
	.dbline 370
; 		
; 		GLCD_ReadRow(x,y,inputCmd, x2); // perform the read, reusing inputCmd buffer
	mov A,[X+4]
	push A
	mov A,>_inputCmd
	push A
	mov A,<_inputCmd
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_ReadRow
	add SP,-5
	.dbline 372
; 		
; 		y2=0;
	mov [X+3],0
	.dbline 373
; 		y2=chksend(y2, 237);
	mov A,-19
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+3],A
	.dbline 374
; 		y2=chksend(y2, x2+5);
	mov A,[X+4]
	add A,5
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+3],A
	.dbline 375
; 		y2=chksend(y2, len);
	mov A,[X+5]
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+3],A
	.dbline 376
; 		y2=chksend(y2, ESUCCESS);
	mov A,0
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+3],A
	.dbline 377
; 		for (pos=0;pos<x2;pos++)
	mov [X+0],0
	xjmp L152
L149:
	.dbline 378
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd
	adc [__r0],>_inputCmd
	mov A,[__r0]
	mov REG[0xd4],A
	mvi A,[__r1]
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+3],A
L150:
	.dbline 377
	inc [X+0]
L152:
	.dbline 377
	mov A,[X+0]
	cmp A,[X+4]
	jz X50
	jc L149
X50:
	.dbline 379
; 			y2=chksend(y2, inputCmd[pos]);
; 		y2=chksend(y2, y2);
	mov A,[X+3]
	push A
	mov A,[X+3]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+3],A
	.dbline 380
; 		return;
	xjmp L66
L138:
	.dbline 384
; 		}
; 
; 	// RAW WRITE:    RxyDDD...DDD
; 	if (inputCmd[BASEOFF]=='R' && len>=3)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],82
	jnz L153
	cmp [X+5],3
	jz X51
	jc L153
X51:
	.dbline 385
; 		{
	.dbline 386
; 		x=inputCmd[BASEOFF+1];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 387
; 		y=inputCmd[BASEOFF+2];
	mov A,[_inputCmd+5]
	mov [X+2],A
	.dbline 388
; 		if (x>127)
	cmp [X+1],127
	jc L158
	jz L158
X52:
	.dbline 389
; 			x=127;
	mov [X+1],127
L158:
	.dbline 390
; 		if (y>63)
	cmp [X+2],63
	jc L160
	jz L160
X53:
	.dbline 391
; 			y=63;
	mov [X+2],63
L160:
	.dbline 396
; 
; 		// we should really ack AFTER doing the work,
; 		// but this should be reliable because of our
; 		// large input buffer.
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	.dbline 398
; 
; 		GLCD_DrawRow(x,y,&inputCmd[BASEOFF+3], len-3);
	mov REG[0xd0],>__r0
	mov A,[X+5]
	sub A,3
	push A
	mov A,>_inputCmd+6
	push A
	mov A,<_inputCmd+6
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawRow
	add SP,-7
	.dbline 399
; 		return;
	xjmp L66
L153:
	.dbline 403
; 		}
; 	
; 	// draw text to the console : WDDDD...
; 	if (inputCmd[BASEOFF]=='W' && len>1)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],87
	jnz L164
	cmp [X+5],1
	jc L164
	jz L164
X54:
	.dbline 404
; 		{
	.dbline 405
; 		inputCmd[BASEOFF+len]=0; // null terminate (overwriting checksum)
	mov REG[0xd0],>__r0
	mov A,[X+5]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3
	adc [__r0],>_inputCmd+3
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 406
; 		GLCD_ConsoleWriteString(&inputCmd[BASEOFF+1]);
	mov A,>_inputCmd+4
	push A
	mov A,<_inputCmd+4
	push A
	xcall _GLCD_ConsoleWriteString
	.dbline 407
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-4
	.dbline 408
; 		return;
	xjmp L66
L164:
	.dbline 412
; 		}
; 
; 	// draw text at top :  txDDDDD...
; 	if (inputCmd[BASEOFF]=='t' && len>=3)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],116
	jnz L170
	cmp [X+5],3
	jz X55
	jc L170
X55:
	.dbline 413
; 		{
	.dbline 414
; 		x=inputCmd[BASEOFF+1];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 415
; 		if (x>127)
	cmp [X+1],127
	jc L174
	jz L174
X56:
	.dbline 416
; 			x=127;		
	mov [X+1],127
L174:
	.dbline 418
; 
; 		inputCmd[BASEOFF+len]=0; // null terminate (overwriting checksum)
	mov REG[0xd0],>__r0
	mov A,[X+5]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3
	adc [__r0],>_inputCmd+3
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 419
; 		GLCD_DrawCharXor=0x7f;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],127
	.dbline 420
; 		GLCD_DrawString(x, 0, &inputCmd[BASEOFF+2], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,>_inputCmd+5
	push A
	mov A,<_inputCmd+5
	push A
	mov A,0
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawString
	.dbline 421
; 		GLCD_DrawCharXor=0x00;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],0
	.dbline 423
; 
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-8
	.dbline 424
; 		return;		
	xjmp L66
L170:
	.dbline 428
; 		}				
; 
; 	// draw text at random position: TxyfDDDD...
; 	if (inputCmd[BASEOFF]=='T' && len>=4)
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],84
	jnz L179
	cmp [X+5],4
	jz X57
	jc L179
X57:
	.dbline 429
; 		{
	.dbline 430
; 		x=inputCmd[BASEOFF+1];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+4]
	mov [X+1],A
	.dbline 431
; 		y=inputCmd[BASEOFF+2];
	mov A,[_inputCmd+5]
	mov [X+2],A
	.dbline 432
; 		if (x>127)
	cmp [X+1],127
	jc L184
	jz L184
X58:
	.dbline 433
; 			x=127;
	mov [X+1],127
L184:
	.dbline 434
; 		if (y>63)
	cmp [X+2],63
	jc L186
	jz L186
X59:
	.dbline 435
; 			y=63;
	mov [X+2],63
L186:
	.dbline 436
; 		if (inputCmd[BASEOFF+3]>='a') // reverse video
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+6],97
	jz X60
	jc L188
X60:
	.dbline 437
; 			GLCD_DrawCharXor=255;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],-1
L188:
	.dbline 439
; 
; 		x2=inputCmd[BASEOFF+3];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+6]
	mov [X+4],A
	.dbline 440
; 		if (x2>='a') // crude toupper()
	cmp [X+4],97
	jz X61
	jc L192
X61:
	.dbline 441
; 			x2-=32;
	mov REG[0xd0],>__r0
	mov A,[X+4]
	sub A,32
	mov [X+4],A
L192:
	.dbline 443
; 		
; 		inputCmd[BASEOFF+len]=0; // null terminate (overwriting checksum)
	mov REG[0xd0],>__r0
	mov A,[X+5]
	mov [__r1],A
	mov [__r0],0
	add [__r1],<_inputCmd+3
	adc [__r0],>_inputCmd+3
	mov A,[__r0]
	mov REG[0xd5],A
	mov A,0
	mvi [__r1],A
	.dbline 445
; 		
; 		if (x2=='A')
	cmp [X+4],65
	jnz L195
	.dbline 446
; 			GLCD_DrawString(x, y, &inputCmd[BASEOFF+4], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,>_inputCmd+7
	push A
	mov A,<_inputCmd+7
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawString
	add SP,-6
	mov REG[0xd0],>__r0
	mov [__r0],A
	xjmp L196
L195:
	.dbline 447
; 		else if (x2=='B')
	cmp [X+4],66
	jnz L198
	.dbline 448
; 			GLCD_DrawString(x, y, &inputCmd[BASEOFF+4], fnt58);
	mov A,>_fnt58
	push A
	mov A,<_fnt58
	push A
	mov A,>_inputCmd+7
	push A
	mov A,<_inputCmd+7
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawString
	add SP,-6
	mov REG[0xd0],>__r0
	mov [__r0],A
	xjmp L199
L198:
	.dbline 449
; 		else if (x2=='C')
	cmp [X+4],67
	jnz L201
	.dbline 450
; 			GLCD_DrawString(x, y, &inputCmd[BASEOFF+4], fnt68);
	mov A,>_fnt68
	push A
	mov A,<_fnt68
	push A
	mov A,>_inputCmd+7
	push A
	mov A,<_inputCmd+7
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawString
	add SP,-6
	mov REG[0xd0],>__r0
	mov [__r0],A
	xjmp L202
L201:
	.dbline 451
; 		else if (x2=='D')
	cmp [X+4],68
	jnz L204
	.dbline 452
; 			GLCD_DrawString(x, y, &inputCmd[BASEOFF+4], fnt88);
	mov A,>_fnt88
	push A
	mov A,<_fnt88
	push A
	mov A,>_inputCmd+7
	push A
	mov A,<_inputCmd+7
	push A
	mov A,[X+2]
	push A
	mov A,[X+1]
	push A
	xcall _GLCD_DrawString
	add SP,-6
	mov REG[0xd0],>__r0
L204:
L202:
L199:
L196:
	.dbline 454
; 		
; 		GLCD_DrawCharXor=0;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],0
	.dbline 456
; 
; 		sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 457
; 		return;
	xjmp L66
L179:
	.dbline 461
; 		}
; 
; 	// SET CONSOLE SIZE: Sthlw
; 	if (inputCmd[BASEOFF]=='S' && len==5) // set the size of the console
	mov REG[0xd0],>_inputCmd
	cmp [_inputCmd+3],83
	jnz L208
	cmp [X+5],5
	jnz L208
	.dbline 462
; 		{
	.dbline 463
; 		 GLCD_ConsoleTop=inputCmd[BASEOFF+1];
	mov A,[_inputCmd+4]
	mov REG[0xd0],>_GLCD_ConsoleTop
	mov [_GLCD_ConsoleTop],A
	.dbline 464
;  		 GLCD_ConsoleHeight=inputCmd[BASEOFF+2];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+5]
	mov REG[0xd0],>_GLCD_ConsoleHeight
	mov [_GLCD_ConsoleHeight],A
	.dbline 465
;  		 GLCD_ConsoleLeft=inputCmd[BASEOFF+3];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+6]
	mov REG[0xd0],>_GLCD_ConsoleLeft
	mov [_GLCD_ConsoleLeft],A
	.dbline 466
;  		 GLCD_ConsoleWidth=inputCmd[BASEOFF+4];
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+7]
	mov REG[0xd0],>_GLCD_ConsoleWidth
	mov [_GLCD_ConsoleWidth],A
	.dbline 468
; 		
; 		 GLCD_ConsoleHome();
	xcall _GLCD_ConsoleHome
	.dbline 469
; 		 sendAck(inputCmd[FLAGSOFF], ESUCCESS);
	mov A,0
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline 470
; 		 return;
	xjmp L66
L208:
	.dbline 474
; 		}
; 	
; 	// dunno what this is. NACK it.
; 	sendAck(inputCmd[FLAGSOFF], EUNKNOWNCMD);
	mov A,3
	push A
	mov REG[0xd0],>_inputCmd
	mov A,[_inputCmd+2]
	push A
	xcall _sendAck
	add SP,-2
	.dbline -2
	.dbline 475
; }
L66:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l len 5 c
	.dbsym l x2 4 c
	.dbsym l y2 3 c
	.dbsym l y 2 c
	.dbsym l x 1 c
	.dbsym l pos 0 c
	.dbend
	.dbfunc e sendAck _sendAck fV
;            chk -> X+0
;          error -> X-5
;          flags -> X-4
_sendAck::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 479
; 
; // note: convention that error==0 means no error
; void sendAck(unsigned char flags, unsigned char error)
; {
	.dbline 480
; 	unsigned char chk=0;
	mov [X+0],0
	.dbline 482
; 	
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 483
; 	chk = chksend(chk, 5);
	mov A,5
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 484
; 	chk = chksend(chk, flags);
	mov A,[X-4]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 485
; 	chk = chksend(chk, error);
	mov A,[X-5]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 486
; 	chk = chksend(chk, chk);
	mov A,[X+0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov [X+0],A
	.dbline 488
; 
; 	inputLen=0;
	mov REG[0xd0],>_inputLen
	mov [_inputLen],0
	.dbline -2
	.dbline 489
; }
L217:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chk 0 c
	.dbsym l error -5 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e SendPacket _SendPacket fV
;            chk -> X+0
;          flags -> X-4
_SendPacket::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 492
; 
; void SendPacket(unsigned char flags)
; {
	.dbline 493
; 	unsigned char chk=0;
	mov [X+0],0
	.dbline 495
; 	
; 	chk = chksend(chk, 237);
	mov A,-19
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-2
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 496
; 	chk = chksend(chk, 13);   // packet length
	mov A,13
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 497
; 	chk = chksend(chk, flags); // host/pad comms, no transID
	mov A,[X-4]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 498
; 	chk = chksend(chk, '*');
	mov A,42
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 499
; 	chk = chksend(chk, convertJoyX());
	xcall _convertJoyX
	mov REG[0xd0],>__r0
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 500
; 	chk = chksend(chk, convertJoyY());
	xcall _convertJoyY
	mov REG[0xd0],>__r0
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov [X+0],A
	.dbline 501
; 	chk = chksend(chk, buttons);
	mov REG[0xd0],>_buttons
	mov A,[_buttons]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov [X+0],A
	.dbline 502
; 	chk = chksend(chk, ((moveup&0xf)<<4) | (movedown&0xf));
	mov REG[0xd0],>_moveup
	mov A,[_moveup]
	and A,15
	mov REG[0xd0],>__r0
	asl A
	asl A
	asl A
	asl A
	mov [__r0],A
	mov REG[0xd0],>_movedown
	mov A,[_movedown]
	and A,15
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov [X+0],A
	.dbline 503
; 	chk = chksend(chk, ((moveleft&0xf)<<4) | (moveright&0xf));
	mov REG[0xd0],>_moveleft
	mov A,[_moveleft]
	and A,15
	mov REG[0xd0],>__r0
	asl A
	asl A
	asl A
	asl A
	mov [__r0],A
	mov REG[0xd0],>_moveright
	mov A,[_moveright]
	and A,15
	mov REG[0xd0],>__r0
	or [__r0],A
	mov A,[__r0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov [X+0],A
	.dbline 504
; 	chk = chksend(chk, batteryvoltage>>8);
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	push A
	mov A,[_batteryvoltage]
	mov REG[0xd0],>__r0
	mov [__r0],A
	pop A
	mov A,[__r0]
	mov [__r1],A
	tst [__r1],-128
	jnz X62
	mov [__r0],0
	jmp X63
X62:
	mov REG[0xd0],>__r0
X63:
	mov REG[0xd0],>__r0
	mov A,[__r1]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov [X+0],A
	.dbline 505
; 	chk = chksend(chk, batteryvoltage&0xff);
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	mov REG[0xd0],>__r0
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov [X+0],A
	.dbline 507
; 
; 	chk = chksend(chk, badchars);
	mov REG[0xd0],>_badchars
	mov A,[_badchars]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 509
; 
; 	chk = chksend(chk, chk);	
	mov A,[X+0]
	push A
	mov A,[X+0]
	push A
	xcall _chksend
	add SP,-4
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline -2
	.dbline 510
; }
L218:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l chk 0 c
	.dbsym l flags -4 c
	.dbend
	.dbfunc e chksend _chksend fc
;              c -> X-5
;            chk -> X-4
_chksend::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 513
; 
; unsigned char chksend(unsigned char chk, unsigned char c)
; {
	.dbline 514
; 	ED_HOST_putData(c);
	push X
	mov A,[X-5]
	xcall _ED_HOST_putData
	pop X
	.dbline 515
; 	return (chk<<1)+c+(chk&0x80 ? 1: 0);
	tst [X-4],-128
	jz L221
	mov [X+1],1
	mov [X+0],0
	xjmp L222
L221:
	mov [X+1],0
	mov [X+0],0
L222:
	mov REG[0xd0],>__r0
	mov A,[X-4]
	mov [__r1],A
	mov [__r0],0
	asl [__r1]
	rlc [__r0]
	mov A,[X-5]
	add [__r1],A
	adc [__r0],0
	mov A,[X+1]
	add [__r1],A
	mov A,[X+0]
	adc [__r0],A
	mov A,[__r1]
	.dbline -2
L219:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l c -5 c
	.dbsym l chk -4 c
	.dbend
	.dbfunc e UpdateAnalog _UpdateAnalog fV
;              v -> X+0
_UpdateAnalog::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 519
; }
; 
; void UpdateAnalog()
; {
	.dbline 522
; 	int v;
; 	
; 	if (!DelSig_1_fIsDataAvailable())
	push X
	xcall _DelSig_1_fIsDataAvailable
	mov REG[0xd0],>__r0
	pop X
	cmp A,0
	jnz L224
	.dbline 523
; 		return;
	xjmp L223
L224:
	.dbline 525
; 
; 	v=DelSig_1_iGetDataClearFlag()>>4;
	push X
	xcall _DelSig_1_iGetDataClearFlag
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov [__r0],X
	pop X
	asr [__r0]
	rrc [__r1]
	asr [__r0]
	rrc [__r1]
	asr [__r0]
	rrc [__r1]
	asr [__r0]
	rrc [__r1]
	mov A,[__r1]
	mov [X+1],A
	mov A,[__r0]
	mov [X+0],A
	.dbline 526
; 	analogcount++;
	mov REG[0xd0],>_analogcount
	inc [_analogcount]
	.dbline 528
; 
; 	if (analogcount<6)
	cmp [_analogcount],6
	jnc L226
X64:
	.dbline 529
; 		return;
	xjmp L223
L226:
	.dbline 530
; 	analogcount=0;
	mov REG[0xd0],>_analogcount
	mov [_analogcount],0
	.dbline 532
; 	
; 	if (analogPort==0)
	mov REG[0xd0],>_analogPort
	cmp [_analogPort],0
	jnz L228
	.dbline 533
; 		{
	.dbline 534
; 		v=1024-v;
	mov A,0
	sub A,[X+1]
	mov [X+1],A
	mov A,4
	sbb A,[X+0]
	mov [X+0],A
	.dbline 535
; 		if (abs(v-joyx)>=4)
	mov REG[0xd0],>_joyx
	mov A,[X+1]
	sub A,[_joyx+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+0]
	mov REG[0xd0],>_joyx
	sbb A,[_joyx]
	mov REG[0xd0],>__r0
	push A
	mov A,[__r1]
	push A
	xcall _abs
	add SP,-2
	mov REG[0xd0],>__r0
	mov A,[__r0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[__r1]
	sub A,4
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L229
X65:
	.dbline 536
; 			{
	.dbline 537
; 			joyx=v;
	mov REG[0xd0],>_joyx
	mov A,[X+1]
	mov [_joyx+1],A
	mov A,[X+0]
	mov [_joyx],A
	.dbline 538
; 			needUpdate=1;
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],1
	.dbline 539
; 			}
	.dbline 540
; 		}
	xjmp L229
L228:
	.dbline 541
; 	else if (analogPort==2)
	mov REG[0xd0],>_analogPort
	cmp [_analogPort],2
	jnz L232
	.dbline 542
; 		{
	.dbline 543
; 		if (abs(v-joyy)>=4)
	mov REG[0xd0],>_joyy
	mov A,[X+1]
	sub A,[_joyy+1]
	mov REG[0xd0],>__r0
	mov [__r1],A
	mov A,[X+0]
	mov REG[0xd0],>_joyy
	sbb A,[_joyy]
	mov REG[0xd0],>__r0
	push A
	mov A,[__r1]
	push A
	xcall _abs
	add SP,-2
	mov REG[0xd0],>__r0
	mov A,[__r0]
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[__r1]
	sub A,4
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L233
X66:
	.dbline 544
; 			{
	.dbline 545
; 			joyy=v;
	mov REG[0xd0],>_joyy
	mov A,[X+1]
	mov [_joyy+1],A
	mov A,[X+0]
	mov [_joyy],A
	.dbline 546
; 			needUpdate=1;
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],1
	.dbline 547
; 			}
	.dbline 548
; 		}
	xjmp L233
L232:
	.dbline 549
; 	else if (analogPort==4)
	mov REG[0xd0],>_analogPort
	cmp [_analogPort],4
	jnz L236
	.dbline 550
; 		{
	.dbline 553
; 			// batteryvoltage is voltage*100, e.g. 1234 = 12.34V
; 			// but batsensedivide is scaled by an extra factor of 10
; 			batteryvoltage=((long) 1000L*v)/params.batsensedivide;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r3],A
	mov A,[X+0]
	mov [__r2],A
	tst [__r2],-128
	jz X67
	mov [__r1],-1
	mov [__r0],-1
	jmp X68
X67:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X68:
	mov REG[0xd0],>__r0
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	mov A,0
	push A
	push A
	mov A,3
	push A
	mov A,-24
	push A
	xcall __mul_32X32_32
	add SP,-4
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	mov REG[0xd0],>_params
	mov A,[_params+12+1]
	mov REG[0xd0],>__r0
	mov [__r7],A
	mov REG[0xd0],>_params
	mov A,[_params+12]
	mov REG[0xd0],>__r0
	mov [__r6],A
	tst [__r6],-128
	jz X69
	mov [__r5],-1
	mov [__r4],-1
	jmp X70
X69:
	mov REG[0xd0],>__r0
	mov [__r5],0
	mov [__r4],0
X70:
	mov REG[0xd0],>__r0
	mov A,[__r4]
	push A
	mov A,[__r5]
	push A
	mov A,[__r6]
	push A
	mov A,[__r7]
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	pop A
	add SP,-4
	mov A,[__r3]
	mov [__r1],A
	mov A,[__r2]
	mov [__r0],A
	mov A,[__r1]
	push A
	mov A,[__r0]
	mov REG[0xd0],>_batteryvoltage
	mov [_batteryvoltage],A
	pop A
	mov [_batteryvoltage+1],A
	.dbline 554
; 		}
L236:
L233:
L229:
	.dbline 557
; 
; 	// rotate the port	
; 	analogPort=analogPort+2;
	mov REG[0xd0],>_analogPort
	add [_analogPort],2
	.dbline 558
; 	if (analogPort>=8)
	cmp [_analogPort],8
	jz X71
	jc L239
X71:
	.dbline 559
; 		analogPort=0;
	mov REG[0xd0],>_analogPort
	mov [_analogPort],0
L239:
	.dbline 561
; 	
; 	AMUX4_1_InputSelect(analogPort>>1);
	mov REG[0xd0],>_analogPort
	mov A,[_analogPort]
	mov REG[0xd0],>__r0
	mov [__r0],A
	and F,-5
	rrc [__r0]
	push X
	mov A,[__r0]
	xcall _AMUX4_1_InputSelect
	pop X
	.dbline -2
	.dbline 562
; }
L223:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l v 0 I
	.dbend
	.dbfunc e UpdateButtons _UpdateButtons fV
;              b -> X+0
_UpdateButtons::
	.dbline -1
	push X
	mov X,SP
	add SP,1
	.dbline 565
	.dbline 569
	mov A,REG[ 0]
	mov REG[0xd0],>__r0
	mov [__r0],A
	and [__r0],-32
	mov A,[__r0]
	asr A
	asr A
	asr A
	asr A
	asr A
	and A,7
	mov [__r0],A
	xor [__r0],7
	mov A,[__r0]
	mov [X+0],A
	.dbline 570
	mov REG[0xd0],>_buttons
	mov A,[X+0]
	cmp A,[_buttons]
	jz L242
	.dbline 571
	.dbline 572
	mov A,[X+0]
	and A,7
	mov [_buttons],A
	.dbline 573
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],1
	.dbline 574
L242:
	.dbline -2
	.dbline 575
; 
; void UpdateButtons(void)
; {
; 	unsigned char b;
; 	
; 	// update button data.		
; 	b=((PRT0DR & PORT0PULLUPS)>>5)^7;
; 	if (b!=buttons)
; 		{
; 		buttons=b&7;
; 		needUpdate=1;
; 		}
; }
L241:
	add SP,-1
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l b 0 c
	.dbend
	.dbfunc e doSleepInterval _doSleepInterval fV
;          joyy2 -> X+1
;          joyx2 -> X+0
_doSleepInterval::
	.dbline -1
	push X
	mov X,SP
	add SP,2
	.dbline 578
; 
; void doSleepInterval()
; {
	.dbline 581
; 	unsigned char joyx2, joyy2;
; 
; 	if (batteryvoltage>=1200)
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,4
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	sub A,-80
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L245
X72:
	.dbline 582
; 	{
	.dbline 583
; 		if (batterystate!=0)
	mov REG[0xd0],>_batterystate
	cmp [_batterystate],0
	jz L246
	.dbline 584
; 		{
	.dbline 585
; 			batterystate=0;
	mov [_batterystate],0
	.dbline 586
; 			PWM16_LOWBAT_WritePeriod(32768);
	push X
	mov X,-128
	mov A,0
	xcall _PWM16_LOWBAT_WritePeriod
	.dbline 587
; 			PWM16_LOWBAT_WritePulseWidth(0);
	mov A,0
	mov X,A
	xcall _PWM16_LOWBAT_WritePulseWidth
	pop X
	.dbline 588
; 		}		
	.dbline 589
	xjmp L246
L245:
	.dbline 589
; 	} else if (batteryvoltage>=1125) {
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,4
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	sub A,101
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L249
X73:
	.dbline 589
	.dbline 590
; 		if (batterystate!=1)
	mov REG[0xd0],>_batterystate
	cmp [_batterystate],1
	jz L250
	.dbline 591
; 		{
	.dbline 592
; 			batterystate=1;
	mov [_batterystate],1
	.dbline 593
; 			PWM16_LOWBAT_WritePeriod(32768);
	push X
	mov X,-128
	mov A,0
	xcall _PWM16_LOWBAT_WritePeriod
	.dbline 594
; 			PWM16_LOWBAT_WritePulseWidth(8192);
	mov X,32
	mov A,0
	xcall _PWM16_LOWBAT_WritePulseWidth
	pop X
	.dbline 595
; 		}
	.dbline 596
	xjmp L250
L249:
	.dbline 596
; 	} else if (batteryvoltage>=1050) {
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,4
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	sub A,26
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L253
X74:
	.dbline 596
	.dbline 597
; 		if (batterystate!=2)
	mov REG[0xd0],>_batterystate
	cmp [_batterystate],2
	jz L254
	.dbline 598
; 		{
	.dbline 599
; 			batterystate=2;
	mov [_batterystate],2
	.dbline 600
; 			PWM16_LOWBAT_WritePeriod(16384);
	push X
	mov X,64
	mov A,0
	xcall _PWM16_LOWBAT_WritePeriod
	.dbline 601
; 			PWM16_LOWBAT_WritePulseWidth(8192);	
	mov X,32
	mov A,0
	xcall _PWM16_LOWBAT_WritePulseWidth
	pop X
	.dbline 602
; 		}
	.dbline 603
	xjmp L254
L253:
	.dbline 603
; 	} else if (batterystate!=3) {
	mov REG[0xd0],>_batterystate
	cmp [_batterystate],3
	jz L257
	.dbline 603
	.dbline 604
; 		batterystate=3;
	mov [_batterystate],3
	.dbline 605
; 		PWM16_LOWBAT_WritePeriod(8192);
	push X
	mov X,32
	mov A,0
	xcall _PWM16_LOWBAT_WritePeriod
	.dbline 606
; 		PWM16_LOWBAT_WritePulseWidth(4096);
	mov X,16
	mov A,0
	xcall _PWM16_LOWBAT_WritePulseWidth
	pop X
	.dbline 607
; 	}
L257:
L254:
L250:
L246:
	.dbline 610
; 	
; 	
; 	batteryUpdateCount--;
	mov REG[0xd0],>_batteryUpdateCount
	dec [_batteryUpdateCount+1]
	sbb [_batteryUpdateCount],0
	.dbline 613
; 	// we don't want to redraw the banner too often, because
; 	// it takes a long time!
; 	if (batteryUpdateCount<=0)
	mov A,[_batteryUpdateCount]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryUpdateCount
	mov A,[_batteryUpdateCount+1]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jz X75
	jnc L259
X75:
	.dbline 614
; 		{
	.dbline 615
; 		batteryUpdateCount=BATTERYUPDATEINTERVAL;
	mov REG[0xd0],>_batteryUpdateCount
	mov [_batteryUpdateCount+1],0
	mov [_batteryUpdateCount],1
	.dbline 616
; 		DrawBatteryVoltage(BATVOLTAGE_X, 0);
	mov A,0
	push A
	mov A,96
	push A
	xcall _DrawBatteryVoltage
	add SP,-2
	.dbline 617
; 		}
L259:
	.dbline 619
; 	
; 	resendtimer--;
	mov REG[0xd0],>_resendtimer
	dec [_resendtimer]
	.dbline 621
; 
; 	if (buttons&2)
	mov REG[0xd0],>_buttons
	tst [_buttons],2
	jz L261
	.dbline 622
; 		{
	.dbline 623
; 		if (buttonDownCount<65534)
	mov REG[0xd0],>_buttonDownCount
	mov A,[_buttonDownCount+1]
	mov REG[0xd0],>__r0
	mov [__r3],A
	mov REG[0xd0],>_buttonDownCount
	mov A,[_buttonDownCount]
	mov REG[0xd0],>__r0
	mov [__r2],A
	mov A,0
	xor A,-128
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov A,[__r3]
	sub A,-2
	or [__rX],A
	mov A,[__r2]
	sbb A,-1
	or [__rX],A
	mov A,0
	sbb A,0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L262
	mov A,[__rX]
	jz L262
X76:
	.dbline 624
; 			buttonDownCount++;
	mov REG[0xd0],>_buttonDownCount
	inc [_buttonDownCount+1]
	adc [_buttonDownCount],0
	.dbline 625
; 		}
	xjmp L262
L261:
	.dbline 627
; 	else
; 		buttonDownCount=0;
	mov REG[0xd0],>_buttonDownCount
	mov [_buttonDownCount+1],0
	mov [_buttonDownCount],0
L262:
	.dbline 629
; 		
; 	lastSleepCounter=sleepcounter;
	mov REG[0xd0],>_sleepcounter
	mov A,[_sleepcounter]
	mov REG[0xd0],>_lastSleepCounter
	mov [_lastSleepCounter],A
	.dbline 630
; 	joyx2=convertJoyX();
	xcall _convertJoyX
	mov REG[0xd0],>__r0
	mov [X+0],A
	.dbline 631
; 	joyy2=convertJoyY();
	xcall _convertJoyY
	mov REG[0xd0],>__r0
	mov [X+1],A
	.dbline 633
; 
; 	if (joyx2>(128+JOY_THRESH_MIN) || joyx2<(128-JOY_THRESH_MIN))
	cmp [X+0],-104
	jz X77
	jnc L267
X77:
	cmp [X+0],104
	jnc L265
X78:
L267:
	.dbline 634
; 		joyxacc+=joyx2-128;
	mov REG[0xd0],>__r0
	mov A,[X+0]
	mov [__r1],A
	mov [__r0],0
	sub [__r1],-128
	sbb [__r0],0
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X79
	mov [__r1],-1
	mov [__r0],-1
	jmp X80
X79:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X80:
	mov REG[0xd0],>__r0
	mov A,[__r3]
	mov REG[0xd0],>_joyxacc
	add [_joyxacc+3],A
	mov REG[0xd0],>__r0
	mov A,[__r2]
	mov REG[0xd0],>_joyxacc
	adc [_joyxacc+2],A
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov REG[0xd0],>_joyxacc
	adc [_joyxacc+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov REG[0xd0],>_joyxacc
	adc [_joyxacc],A
	xjmp L266
L265:
	.dbline 636
; 	else
; 		{
	.dbline 637
; 		if (joyxacc>JOY_THRESH_PRESS)
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+2]
	sbb A,8
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+1]
	sbb A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L268
	mov A,[__rX]
	jz L268
X81:
	.dbline 638
; 			{
	.dbline 639
; 			moveright++;
	mov REG[0xd0],>_moveright
	inc [_moveright]
	.dbline 640
; 			goto gotpress;
	xjmp L270
L268:
	.dbline 642
; 			}
; 		if (joyxacc<-JOY_THRESH_PRESS)
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,-1
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+2]
	sbb A,-8
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+1]
	sbb A,-1
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L271
	mov A,[__rX]
	jz L271
X82:
	.dbline 643
; 			{
	.dbline 644
; 			moveleft++;
	mov REG[0xd0],>_moveleft
	inc [_moveleft]
	.dbline 645
; 			goto gotpress;
	xjmp L270
L271:
	.dbline 647
; 			}		
; 		}
L266:
	.dbline 649
; 
; 	if (joyy2>(128+JOY_THRESH_MIN) || joyy2<(128-JOY_THRESH_MIN))
	cmp [X+1],-104
	jz X83
	jnc L275
X83:
	cmp [X+1],104
	jnc L273
X84:
L275:
	.dbline 650
; 		joyyacc+=joyy2-128;
	mov REG[0xd0],>__r0
	mov A,[X+1]
	mov [__r1],A
	mov [__r0],0
	sub [__r1],-128
	sbb [__r0],0
	mov A,[__r1]
	mov [__r3],A
	mov A,[__r0]
	mov [__r2],A
	tst [__r2],-128
	jz X85
	mov [__r1],-1
	mov [__r0],-1
	jmp X86
X85:
	mov REG[0xd0],>__r0
	mov [__r1],0
	mov [__r0],0
X86:
	mov REG[0xd0],>__r0
	mov A,[__r3]
	mov REG[0xd0],>_joyyacc
	add [_joyyacc+3],A
	mov REG[0xd0],>__r0
	mov A,[__r2]
	mov REG[0xd0],>_joyyacc
	adc [_joyyacc+2],A
	mov REG[0xd0],>__r0
	mov A,[__r1]
	mov REG[0xd0],>_joyyacc
	adc [_joyyacc+1],A
	mov REG[0xd0],>__r0
	mov A,[__r0]
	mov REG[0xd0],>_joyyacc
	adc [_joyyacc],A
	xjmp L274
L273:
	.dbline 652
; 	else
; 		{
	.dbline 653
; 		if (joyyacc>JOY_THRESH_PRESS)
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+2]
	sbb A,8
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+1]
	sbb A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L276
	mov A,[__rX]
	jz L276
X87:
	.dbline 654
; 			{
	.dbline 655
; 			movedown++;
	mov REG[0xd0],>_movedown
	inc [_movedown]
	.dbline 656
; 			goto gotpress;
	xjmp L270
L276:
	.dbline 658
; 			}
; 		if (joyyacc<-JOY_THRESH_PRESS)
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,-1
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+2]
	sbb A,-8
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+1]
	sbb A,-1
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L278
	mov A,[__rX]
	jz L278
X88:
	.dbline 659
; 			{
	.dbline 660
; 			moveup++;
	mov REG[0xd0],>_moveup
	inc [_moveup]
	.dbline 661
; 			goto gotpress;
	xjmp L270
L278:
	.dbline 663
; 			}		
; 		}
L274:
	.dbline 665
; 
; 	if (joyxacc>JOY_THRESH_AUTOREPEAT)
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+2]
	sbb A,72
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+1]
	sbb A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L280
	mov A,[__rX]
	jz L280
X89:
	.dbline 666
; 		{
	.dbline 667
; 		moveright++;
	mov REG[0xd0],>_moveright
	inc [_moveright]
	.dbline 668
; 		goto gotautokey;
	xjmp L282
L280:
	.dbline 670
; 		}
; 	if (joyxacc<-JOY_THRESH_AUTOREPEAT)
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,-1
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+2]
	sbb A,-72
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc+1]
	sbb A,-1
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L283
	mov A,[__rX]
	jz L283
X90:
	.dbline 671
; 		{
	.dbline 672
; 		moveleft++;
	mov REG[0xd0],>_moveleft
	inc [_moveleft]
	.dbline 673
; 		goto gotautokey;
	xjmp L282
L283:
	.dbline 675
; 		}
; 	if (joyyacc>JOY_THRESH_AUTOREPEAT)
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+2]
	sbb A,72
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+1]
	sbb A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L285
	mov A,[__rX]
	jz L285
X91:
	.dbline 676
; 		{
	.dbline 677
; 		movedown++;
	mov REG[0xd0],>_movedown
	inc [_movedown]
	.dbline 678
; 		goto gotautokey;
	xjmp L282
L285:
	.dbline 680
; 		}
; 	if (joyyacc<-JOY_THRESH_AUTOREPEAT)
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,-1
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+3]
	sub A,0
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+2]
	sbb A,-72
	mov REG[0xd0],>__r0
	or [__rX],A
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc+1]
	sbb A,-1
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jnc L244
	mov A,[__rX]
	jz L244
X92:
	.dbline 681
; 		{
	.dbline 682
; 		moveup++;
	mov REG[0xd0],>_moveup
	inc [_moveup]
	.dbline 683
; 		goto gotautokey;
	.dbline 685
; 		}
; 	return;
L282:
	.dbline 688
; 	
; 	gotautokey:
; 		joyxacc=joyxacc*2/3;
	mov REG[0xd0],>_joyxacc
	mov A,[_joyxacc]
	push A
	mov A,[_joyxacc+1]
	push A
	mov A,[_joyxacc+2]
	push A
	mov A,[_joyxacc+3]
	mov REG[0xd0],>__r0
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	asl [__r3]
	rlc [__r2]
	rlc [__r1]
	rlc [__r0]
	mov A,0
	push A
	push A
	push A
	mov A,3
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov REG[0xd0],>_joyxacc
	mov [_joyxacc+3],A
	pop A
	mov [_joyxacc+2],A
	pop A
	mov [_joyxacc+1],A
	pop A
	mov [_joyxacc],A
	add SP,-4
	.dbline 689
; 		joyyacc=joyyacc*2/3;
	mov REG[0xd0],>_joyyacc
	mov A,[_joyyacc]
	push A
	mov A,[_joyyacc+1]
	push A
	mov A,[_joyyacc+2]
	push A
	mov A,[_joyyacc+3]
	mov REG[0xd0],>__r0
	mov [__r3],A
	pop A
	mov [__r2],A
	pop A
	mov [__r1],A
	pop A
	mov [__r0],A
	asl [__r3]
	rlc [__r2]
	rlc [__r1]
	rlc [__r0]
	mov A,0
	push A
	push A
	push A
	mov A,3
	push A
	mov A,[__r0]
	push A
	mov A,[__r1]
	push A
	mov A,[__r2]
	push A
	mov A,[__r3]
	push A
	xcall __divmod_32X32_32
	pop A
	mov REG[0xd0],>_joyyacc
	mov [_joyyacc+3],A
	pop A
	mov [_joyyacc+2],A
	pop A
	mov [_joyyacc+1],A
	pop A
	mov [_joyyacc],A
	add SP,-4
	.dbline 690
; 		needUpdate=1;
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],1
	.dbline 691
; 		return;
	xjmp L244
L270:
	.dbline 694
; 
; 	gotpress:
; 		joyxacc=0;
	mov REG[0xd0],>_joyxacc
	mov [_joyxacc],0
	mov [_joyxacc+1],0
	mov [_joyxacc+2],0
	mov [_joyxacc+3],0
	.dbline 695
; 		joyyacc=0;
	mov REG[0xd0],>_joyyacc
	mov [_joyyacc],0
	mov [_joyyacc+1],0
	mov [_joyyacc+2],0
	mov [_joyyacc+3],0
	.dbline 696
; 		needUpdate=1;
	mov REG[0xd0],>_needUpdate
	mov [_needUpdate],1
	.dbline 697
; 		return;
	.dbline -2
L244:
	add SP,-2
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l joyy2 1 c
	.dbsym l joyx2 0 c
	.dbend
	.dbfunc e DrawBatteryVoltage _DrawBatteryVoltage fV
;              s -> X+0
;              y -> X-5
;              x -> X-4
_DrawBatteryVoltage::
	.dbline -1
	push X
	mov X,SP
	add SP,6
	.dbline 702
; 	
; }
; 
; void DrawBatteryVoltage(unsigned char x, unsigned char y)
; {
	.dbline 705
; 	unsigned char s[6];
; 	
; 	itoa(s, batteryvoltage, 10);
	mov A,0
	push A
	mov A,10
	push A
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	push A
	mov A,[_batteryvoltage+1]
	push A
	mov REG[0xd0],>__r0
	mov A,7
	push A
	push X
	xcall _itoa
	.dbline 707
; 	
; 	GLCD_DrawCharXor=0x7f;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],127
	.dbline 709
; 
; 	x+=GLCD_DrawChar(x, y, ' ', fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,32
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-11
	add [X-4],A
	.dbline 711
; 	
; 	if (batteryvoltage>=1000)
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,3
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	sub A,-24
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L290
X93:
	.dbline 712
; 		{
	.dbline 713
; 		x+=GLCD_DrawChar(x, y, s[0], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+0]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 714
; 		x+=GLCD_DrawChar(x, y, s[1], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+1]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 715
; 		x+=GLCD_DrawChar(x, y, '.', fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,46
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-10
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 716
; 		x+=GLCD_DrawChar(x, y, s[2], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+2]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 717
; 		x+=GLCD_DrawChar(x, y, s[3], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+3]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-10
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 718
; 		}
	xjmp L291
L290:
	.dbline 719
; 	else if (batteryvoltage>=100)
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage]
	xor A,-128
	mov REG[0xd0],>__r0
	mov [__rY],A
	mov A,0
	xor A,-128
	mov [__rZ],A
	mov [__rX],0
	mov REG[0xd0],>_batteryvoltage
	mov A,[_batteryvoltage+1]
	sub A,100
	mov REG[0xd0],>__r0
	or [__rX],A
	mov A,[__rY]
	sbb A,[__rZ]
	or [__rX],A
	jc L295
X94:
	.dbline 720
; 		{
	.dbline 721
; 		x+=GLCD_DrawChar(x, y, ' ', fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,32
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-5
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 722
; 		x+=GLCD_DrawChar(x, y, s[0], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+0]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 723
; 		x+=GLCD_DrawChar(x, y, '.', fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,46
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-10
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 724
; 		x+=GLCD_DrawChar(x, y, s[1], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+1]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 725
; 		x+=GLCD_DrawChar(x, y, s[2], fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,[X+2]
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawChar
	add SP,-10
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 726
; 		}
	xjmp L296
L295:
	.dbline 728
; 	else
; 		{
	.dbline 729
; 		x+=GLCD_DrawStringC(x, y, "??INV", fnt46);
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,>L299
	push A
	mov A,<L299
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawStringC
	add SP,-6
	mov REG[0xd0],>__r0
	add [X-4],A
	.dbline 730
; 		}
L296:
L291:
	.dbline 731
; 	x+=GLCD_DrawStringC(x, y, "V ", fnt46);		
	mov A,>_fnt46
	push A
	mov A,<_fnt46
	push A
	mov A,>L300
	push A
	mov A,<L300
	push A
	mov A,[X-5]
	push A
	mov A,[X-4]
	push A
	xcall _GLCD_DrawStringC
	add SP,-6
	add [X-4],A
	.dbline 733
; 
; 	GLCD_DrawCharXor=0x00;
	mov REG[0xd0],>_GLCD_DrawCharXor
	mov [_GLCD_DrawCharXor],0
	.dbline -2
	.dbline 735
; 	
; }
L289:
	add SP,-6
	pop X
	.dbline 0 ; func end
	ret
	.dbsym l s 0 A[6:6]c
	.dbsym l y -5 c
	.dbsym l x -4 c
	.dbend
	.area data(ram, con, rel)
	.dbfile ./main.c
_lastSleepCounter::
	.byte 0
	.dbsym e lastSleepCounter _lastSleepCounter c
	.area data(ram, con, rel)
	.dbfile ./main.c
_debounceDelay::
	.byte 0,0
	.dbsym e debounceDelay _debounceDelay I
	.area data(ram, con, rel)
	.dbfile ./main.c
_buttons::
	.byte 0
	.dbsym e buttons _buttons c
	.area data(ram, con, rel)
	.dbfile ./main.c
_batteryUpdateCount::
	.byte 0,0
	.dbsym e batteryUpdateCount _batteryUpdateCount I
	.area data(ram, con, rel)
	.dbfile ./main.c
_batteryvoltage::
	.byte 0,0
	.dbsym e batteryvoltage _batteryvoltage I
	.area data(ram, con, rel)
	.dbfile ./main.c
_joyy::
	.byte 0,0
	.dbsym e joyy _joyy I
	.area data(ram, con, rel)
	.dbfile ./main.c
_joyx::
	.byte 0,0
	.dbsym e joyx _joyx I
	.area data(ram, con, rel)
	.dbfile ./main.c
_inputCmd::
	.word 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.word 0,0,0,0,0
	.byte 0,0
	.dbsym e inputCmd _inputCmd A[72:72]c
	.area lit(rom, con, rel)
L300:
	.byte 'V,32,0
L299:
	.byte 63,63,'I,'N,'V,0
L130:
	.byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	.byte 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	.byte 0
