//*****************************************************************************
//*****************************************************************************
//  FILENAME: DelSig_1.h
//   Version: 1.0, Updated on 2004/08/11 at 11:08:56
//
//  DESCRIPTION:  C declarations for the DelSig User Module with a 2nd-order
//                modulator based on a type-2 dcecimator
//-----------------------------------------------------------------------------
//      Copyright (c) Cypress MicroSystems 2004. All Rights Reserved.
//*****************************************************************************
//*****************************************************************************

#include <m8c.h>

#pragma fastcall16 DelSig_1_Start
#pragma fastcall16 DelSig_1_SetPower
#pragma fastcall16 DelSig_1_StartAD
#pragma fastcall16 DelSig_1_StopAD
#pragma fastcall16 DelSig_1_Stop
#pragma fastcall16 DelSig_1_fIsDataAvailable
#pragma fastcall16 DelSig_1_iGetData
#pragma fastcall16 DelSig_1_wGetData
#pragma fastcall16 DelSig_1_iGetDataClearFlag
#pragma fastcall16 DelSig_1_wGetDataClearFlag
#pragma fastcall16 DelSig_1_ClearFlag
#pragma fastcall16 DelSig_1_WritePulseWidth

//-------------------------------------------------
// Prototypes of the DelSig_1 API.
//-------------------------------------------------
extern void DelSig_1_Start(BYTE bPower);
extern void DelSig_1_SetPower(BYTE bPower);
extern void DelSig_1_StartAD(void);
extern void DelSig_1_StopAD(void);
extern void DelSig_1_Stop(void);
extern BOOL DelSig_1_fIsDataAvailable(void);
extern INT  DelSig_1_iGetData(void);
extern WORD DelSig_1_wGetData(void);
extern INT  DelSig_1_iGetDataClearFlag(void);
extern WORD DelSig_1_wGetDataClearFlag(void);
extern void DelSig_1_ClearFlag(void);
extern void DelSig_1_WritePulseWidth(WORD wPulseWidthValue);

//-------------------------------------------------
// Defines for DelSig_1 API's.
//-------------------------------------------------
#define DelSig_1_OFF                       (0)
#define DelSig_1_LOWPOWER                  (1)
#define DelSig_1_MEDPOWER                  (2)
#define DelSig_1_HIGHPOWER                 (3)

#define DelSig_1_DATA_READY_BIT            (0x10)
#define DelSig_1_2S_COMPLEMENT             (0)

//-------------------------------------------------
// Hardware Register Definitions
//-------------------------------------------------

#pragma ioport  DelSig_1_PWM_DR0_MSB:   0x024           //Time base Counter register
BYTE            DelSig_1_PWM_DR0_MSB;
#pragma ioport  DelSig_1_PWM_DR0_LSB:   0x020
BYTE            DelSig_1_PWM_DR0_LSB;
#pragma ioport  DelSig_1_PWM_DR1_MSB:   0x025           //Time base Period value register
BYTE            DelSig_1_PWM_DR1_MSB;
#pragma ioport  DelSig_1_PWM_DR1_LSB:   0x021
BYTE            DelSig_1_PWM_DR1_LSB;
#pragma ioport  DelSig_1_PWM_DR2_MSB:   0x026           //Time base CompareValue register
BYTE            DelSig_1_PWM_DR2_MSB;
#pragma ioport  DelSig_1_PWM_DR2_LSB:   0x022
BYTE            DelSig_1_PWM_DR2_LSB;
#pragma ioport  DelSig_1_PWM_CR0_MSB:   0x027           //Time base Control register
BYTE            DelSig_1_PWM_CR0_MSB;
#pragma ioport  DelSig_1_PWM_CR0_LSB:   0x023
BYTE            DelSig_1_PWM_CR0_LSB;
#pragma ioport  DelSig_1_PWM_FN_MSB:    0x124            //Time base Function register
BYTE            DelSig_1_PWM_FN_MSB;
#pragma ioport  DelSig_1_PWM_FN_LSB:    0x120
BYTE            DelSig_1_PWM_FN_LSB;
#pragma ioport  DelSig_1_PWM_SL_MSB:    0x125            //Time base Input register
BYTE            DelSig_1_PWM_SL_MSB;
#pragma ioport  DelSig_1_PWM_SL_LSB:    0x121
BYTE            DelSig_1_PWM_SL_LSB;
#pragma ioport  DelSig_1_PWM_OS_MSB:    0x126            //Time base Output register
BYTE            DelSig_1_PWM_OS_MSB;
#pragma ioport  DelSig_1_PWM_OS_LSB:    0x122
BYTE            DelSig_1_PWM_OS_LSB;

#pragma ioport  DelSig_1_AtoD1cr0:  0x09c              //Analog block 1 control register 0
BYTE            DelSig_1_AtoD1cr0;
#pragma ioport  DelSig_1_AtoD1cr1:  0x09d              //Analog block 1 control register 1
BYTE            DelSig_1_AtoD1cr1;
#pragma ioport  DelSig_1_AtoD1cr2:  0x09e              //Analog block 1 control register 2
BYTE            DelSig_1_AtoD1cr2;
#pragma ioport  DelSig_1_AtoD1cr3:  0x09f              //Analog block 1 control register 3
BYTE            DelSig_1_AtoD1cr3;
#pragma ioport  DelSig_1_AtoD2cr0:  0x08c              //Analog block 2 control register 0
BYTE            DelSig_1_AtoD2cr0;
#pragma ioport  DelSig_1_AtoD2cr1:  0x08d              //Analog block 2 control register 1
BYTE            DelSig_1_AtoD2cr1;
#pragma ioport  DelSig_1_AtoD2cr2:  0x08e              //Analog block 2 control register 2
BYTE            DelSig_1_AtoD2cr2;
#pragma ioport  DelSig_1_AtoD2cr3:  0x08f              //Analog block 2 control register 3
BYTE            DelSig_1_AtoD2cr3;


// end of file DelSig_1.h
