#include "config.h"
#include <flashblock.h>

params_t params;


#pragma abs_address: 0x7fc0
params_t defaultparams={512, 512, 0, 0, 1024, 1024, 412};
#pragma end_abs_address


void loadPrefs()
{
	FLASH_READ_STRUCT frs;
	 
	frs.wARG_BlockId = FLASHBLOCKNUMBER;		// Block Id to write
	frs.pARG_FlashBuffer = (unsigned char*) &params;
	frs.wARG_ReadCount = sizeof(params);
	
	FlashReadBlock(&frs);
	
	// sanity check parameters (mostly intended for the
	// first time, when the flash contains garbage.)
	if (params.joycx<100 || params.joycx>900)
		params.joycx=512;
		
	if (params.joycy<100 || params.joycy>900)
		params.joycy=512;

	if (params.batsensedivide<100 || params.batsensedivide>1000)
		params.batsensedivide=412;

	if (params.joyxmin>250 || params.joyxmin<0)
		params.joyxmin=0;

	if (params.joyymin>250 || params.joyymin<0)
		params.joyymin=0;
	
	if (params.joyxmax<700 || params.joyxmax>1024)
		params.joyxmax=1024;
		
	if (params.joyymax<700 || params.joyymax>1024)
		params.joyymax=1024;
}

unsigned char savePrefs()
{
 FLASH_WRITE_STRUCT fws;
 
 fws.wARG_BlockId = FLASHBLOCKNUMBER;		// Block Id to write
 fws.pARG_FlashBuffer = (unsigned char*)  &params;
 fws.cARG_Temperature = 25;	
 
 return bFlashWriteBlock(&fws);
}
