#ifndef _GLCD_H
#define _GLCD_H

#include "m8c.h"


#define DATABUS_WRITE PRT2DM0=0xff; PRT2DM1=0x00
#define DATABUS_READ PRT2DM0=0x00; PRT2DM1=0xff

#define DATABUS PRT2DR
#define CONTROLS PRT1DR

// these defines are "positive" logic. These are what get passed
// as chipsel arguments.
#define CHIPSEL1 CS2
#define CHIPSEL2 CS1

#define ENABLE 0x80
#define DI 0x40
#define RW 0x20
#define RST 0x10
#define CS2 0x8
#define CS1 0x4

extern BYTE GLCD_ConsoleTop;
extern BYTE GLCD_ConsoleHeight;
extern BYTE GLCD_ConsoleLeft;
extern BYTE GLCD_ConsoleWidth;
extern BYTE GLCD_ConsoleX;
extern BYTE GLCD_ConsoleY;
extern BYTE	GLCD_ConsoleNewlinePending;

extern BYTE GLCD_DrawCharXor;

void GLCD_Init(void);

void GLCD_DrawImage(const BYTE *i);
BYTE GLCD_DrawChar(BYTE x, BYTE y, BYTE c, const BYTE *font);
BYTE GLCD_DrawString(BYTE x, BYTE y, char *c, const BYTE *font);
BYTE GLCD_DrawStringC(BYTE x, BYTE y, const char *c, const BYTE *font);
void GLCD_Plot(BYTE x, BYTE y, BYTE mode);
void GLCD_Clear(void);
void GLCD_Fill(BYTE backgroundeven, BYTE backgroundodd);

void GLCD_DrawLine(unsigned char x0, unsigned char y0, 
				   unsigned char x1, unsigned char y1, unsigned char m);

void GLCD_DrawRow(BYTE x, BYTE y, BYTE *data, BYTE len);
void GLCD_ReadRow(BYTE x, BYTE y, BYTE *data, BYTE len);

void GLCD_ConsoleWriteChar(char c);
void GLCD_ConsoleWriteString(char *c);
void GLCD_ConsoleWriteStringC(const char *c);
void GLCD_ConsoleEraseLine(BYTE line);
void GLCD_ConsoleHome(void);
void GLCD_ConsoleScroll(void);

#define MODE_ERASE 0
#define MODE_PLOT 1
#define MODE_XOR 2

#endif