;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM16_LOWBAT.inc
;;   Version: 2.4, Updated on 2004/10/27 at 18:26:14
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the PWM16 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM16_LOWBAT API's.
;--------------------------------------------------

PWM16_LOWBAT_CONTROL_REG_START_BIT:        equ 0x01    ; Control register start bit
PWM16_LOWBAT_INT_REG:                      equ 0x0e1
PWM16_LOWBAT_INT_MASK:                     equ 0x20


;--------------------------------------------------
; Constants for PWM16_LOWBAT user defined values
;--------------------------------------------------

PWM16_LOWBAT_PERIOD:                       equ 0x8000
PWM16_LOWBAT_PULSE_WIDTH:                  equ 0x3e8


;--------------------------------------------------
; Register Address Constants for PWM16_LOWBAT
;--------------------------------------------------

PWM16_LOWBAT_COUNTER_LSB_REG:          equ 0x30   ; DR0 Count register
PWM16_LOWBAT_COUNTER_MSB_REG:          equ 0x34
PWM16_LOWBAT_PERIOD_LSB_REG:           equ 0x31   ; DR1 Period register
PWM16_LOWBAT_PERIOD_MSB_REG:           equ 0x35
PWM16_LOWBAT_COMPARE_LSB_REG:          equ 0x32   ; DR2 Compare register
PWM16_LOWBAT_COMPARE_MSB_REG:          equ 0x36
PWM16_LOWBAT_CONTROL_LSB_REG:          equ 0x33   ; Control register
PWM16_LOWBAT_CONTROL_MSB_REG:          equ 0x37
PWM16_LOWBAT_FUNC_LSB_REG:             equ 0x30   ; Function register
PWM16_LOWBAT_FUNC_MSB_REG:             equ 0x34
PWM16_LOWBAT_INPUT_LSB_REG:            equ 0x31   ; Input register
PWM16_LOWBAT_INPUT_MSB_REG:            equ 0x35
PWM16_LOWBAT_OUTPUT_LSB_REG:           equ 0x32   ; Output register
PWM16_LOWBAT_OUTPUT_MSB_REG:           equ 0x36


;--------------------------------------------------
; PWM16_LOWBAT Macro 'Functions'
;--------------------------------------------------

   macro PWM16_LOWBAT_Start_M
   or    reg[PWM16_LOWBAT_CONTROL_LSB_REG],  PWM16_LOWBAT_CONTROL_REG_START_BIT
   endm

   macro PWM16_LOWBAT_Stop_M
   and   reg[PWM16_LOWBAT_CONTROL_LSB_REG], ~PWM16_LOWBAT_CONTROL_REG_START_BIT
   endm

   macro PWM16_LOWBAT_EnableInt_M
   M8C_EnableIntMask PWM16_LOWBAT_INT_REG, PWM16_LOWBAT_INT_MASK
   endm

   macro PWM16_LOWBAT_DisableInt_M
   M8C_DisableIntMask PWM16_LOWBAT_INT_REG, PWM16_LOWBAT_INT_MASK
   endm


; end of file PWM16_LOWBAT.inc

