function p = gauss_logProb(x, u, c)
% x is a matrix of columns or cell array.

if isa(x, 'cell')
  % convert to a matrix (2 means horizontal concatenation)
  x = cat(2, x{:});
end

[d, n] = size(x);
ic = inv(c);

% Mahalanobis distance
dx = x - repeatcol(u, n);
icdx = ic*dx;
dist = safe_sum(dx .* icdx);

k = log(det(ic)) - d*log(2*pi);
p = (k - dist)/2;
