function x = gauss_sample(u, c, n)
% u is a column
% c is a covariance matrix
% n is the number of samples

if nargin < 3
  n = 1;
end
d = rows(u);
x = randn(d, n);
x = real(eig_root(c)) * x;
x = x + repeatcol(u, n);
