function m = lattice(ranges)
% Returns a matrix where each column is a point on the lattice defined by 
% ranges.  Each dimension is sampled according to 
% ranges(i,1):ranges(i,2):ranges(i,3), with the last dimension sampled
% fastest.

d = rows(ranges);
r = ranges(1,1):ranges(1,2):ranges(1,3);
if(d == 1)
  m = r;
  return;
end

% recurse
y = lattice(ranges(2:d, :));

m = [];
for x = r
  % prepend x to all columns of y
  z = [repeatcol(x, cols(y)); y];
  % append to m
  m = [m z];
end
