function spl = normrnd_mt(n, u, C, vbr, ivbr)
% sample n vectors from a multivariate norm N(u,C)
% each column of spl is a sampled data point

if nargin < 5
   if nargin < 4 
        vbr = ( chol(C) )'; % Cov = vbr* vbr';
    end
    spl =[];
    d = length(u);
    spl = repmat(u,1,n ) + vbr * normrnd(0, 1, d, n);
else
    d = length(u);
    spl = repmat(u,1,n ) + tri_inv_times(ivbr, normrnd(0, 1, d, n));
end

% for i = 1:n
%   spl(:,i) = u + vbr * normrnd(0, 1, d, 1);
% end